<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:user="http://bosch.com" xmlns:cfg=".">
  <!--
BOSCH Security Sytems (Ottobrunn)

Project: Magic.Panel

Author: Michael Ziegel

Created: 01.10.2005

$Archive:   //ot1esw2/MagicPanel/PVCS MP-SW/archives/MP_SW/MP_PC_SW/Transformer/Conversion/XSLT/conv-1-0-0-to-1-1-0.xsl-arc  $  

$Revision: 1.54 $ 

Last locked:   $Date: 2014/04/25 12:48:42MESZ $

Last change by $Author: Maria Lux (lux2ot) $

History: 
$Log: normalize-local-2-0-0.xsl  $
Revision 1.54 2014/04/25 12:48:42MESZ Maria Lux (lux2ot) 
handling of color LCT_UNUSED added
Revision 1.53 2014/04/03 11:03:15MESZ Maria Lux (lux2ot) 
correction;
<color>LCT_UNUSED</color> is removed
Revision 1.52 2014/03/10 09:12:46MEZ Maria Lux (lux2ot) 
xmlValidation must not be compared
Revision 1.51 2012/12/13 09:51:55MEZ Michael Ziegel (zi82ot) 
RLHV und RLHVI changed
Revision 1.50 2012/04/20 10:24:18MESZ Michael Ziegel (zi82ot) 
hide supervised
Revision 1.49 2012/03/27 14:46:37MESZ Michael Ziegel (zi82ot) 
set mks revisions
Revision 1.48 2012/03/27 14:23:11MESZ Michael Ziegel (zi82ot) 
sort ACTIVITYTEXTS by name()
Revision 1.47 2012/03/13 16:05:27MEZ Michael Ziegel (zi82ot) 
RULE/note and RULE_STATE/note normalized version dependent
Revision 1.46 2011/12/02 13:18:54MEZ Michael Ziegel (zi82ot) 
ACTIVITEXTS cannot be sorted, not compared
Revision 1.45 2011/05/25 12:45:59MESZ Michael Ziegel (zi82ot) 
do not hide values of RELAY/supervised
Revision 1.44 2011/02/25 15:27:36MEZ Michael Ziegel (zi82ot) 
RemoveAttributes is switchable
Revision 1.43 2010/07/01 13:21:30CEST Michael Ziegel (zi82ot) 
Member moved from DownUpTest/normalize-local-2-0-0.xsl in project f:/MKS_Repository/Fire/MagicPanel/Source/PCTools/Transformer/Transformer.pj to normalize-local-2-0-0.xsl in project f:/MKS_Repository/Fire/MagicPanel/Source/PCTools/Testing/DownUpTest/DownUpTest.pj.
Revision 1.42 2010/07/01 13:21:30CEST Michael Ziegel (zi82ot) 
adaptions to2.8
Revision 1.41 2009/12/16 14:57:00CET Michael Ziegel (zi82ot) 
feedbackDelay not compared if si-zero
Revision 1.40 2009/12/03 13:59:37CET Michael Ziegel (zi82ot) 
sounders MSS400/401 FNM-420 compare more values if si-zero
Revision 1.39 2009/10/26 14:14:22CET Michael Ziegel (zi82ot) 
.
Revision 1.38 2009/09/17 10:03:38CEST Michael Ziegel (zi82ot) 
no labels if siNumber = 0
Revision 1.37 2009/07/15 12:59:48CEST Michael Ziegel (zi82ot) 
LSN_NAC as NAC or Control
Revision 1.36 2009/06/19 16:25:28CEST Michael Ziegel (zi82ot) 
Drop LSN_BUS with no elements
Revision 1.35 2009/06/18 10:28:20CEST Michael Ziegel (zi82ot) 
display feedbackDelay in RMHV/RELAY[2] if used as FireExt2005
Revision 1.34 2009/06/08 09:13:45CEST Michael Ziegel (zi82ot) 
d
Revision 1.33 2009/05/13 09:44:49CEST Michael Ziegel (zi82ot) 
GLTZONE
Revision 1.32 2009/05/08 12:42:41CEST Michael Ziegel (zi82ot) 
sort activitytexts
Revision 1.31 2009/05/07 15:54:26CEST Michael Ziegel (zi82ot) 
sumcounter
Revision 1.30 2009/05/07 10:21:14CEST Michael Ziegel (zi82ot) 
.
Revision 1.29 2009/03/24 14:50:18CET Michael Ziegel (zi82ot) 
show elments in relay that are used by input
Revision 1.28 2009/03/19 15:51:39CET Michael Ziegel (zi82ot) 
handle VAS_TRIGGERs
Revision 1.27 2009/01/23 10:04:24CET Michael Ziegel (zi82ot) 
dont compare siTypes of unsed items
Revision 1.26 2009/01/20 12:44:40CET Michael Ziegel (zi82ot) 
show siType even when siNumber = 0
Revision 1.25 2008/10/16 14:22:50CEST Michael Ziegel (zi82ot) 
hh
Revision 1.24 2008/03/26 14:13:01CET zi82ot 
cfgversion targetschemaversion in enviro
Revision 1.23 2008/03/25 16:11:31CET zi82ot 
n
Revision 1.22 2008/03/19 15:28:35CET zi82ot 
.
Revision 1.21 2008/03/18 15:39:10CET zi82ot 
sorting enhanced
Revision 1.20 2008/03/07 15:38:57CET zi82ot 
rekursive SI-ZERO
Revision 1.19 2008/03/06 12:37:27CET zi82ot 
New RULE sorting and RULE_STATE_BLOCK handled
Revision 1.18 2008/03/03 16:03:44CET zi82ot 
,,
Revision 1.17 2008/02/13 16:19:10CET zi82ot 
..
Revision 1.16 2008/02/08 14:34:48CET zi82ot 
.
Revision 1.15 2008/02/07 13:44:42CET zi82ot 
SBsRC used
Revision 1.14 2008/01/14 16:17:17CET zi82ot 
.
Revision 1.13 2007/12/05 11:02:42CET zi82ot 
sort SET/element and drop duplicated entries
Revision 1.3 2007/09/04 11:47:46CEST zi82ot 
show new elments in CONFIG_INFO
Revision 1.2 2007/08/30 14:32:30CEST zi82ot 
updated
Revision 1.1 2007/08/29 15:50:35CEST zi82ot 
Initial revision
Member added to project f:/MKS_Repository/Fire/MagicPanel/Source/PCTools/Transformer/Transformer.pj
Revision 1.5 2007/03/20 13:47:10CET zi82ot 
PRINTER may contain UART or OB_UART
Revision 1.4 2007/01/15 13:34:37CET zi82ot 
Adapted to Network and FSP-structure
Revision 1.3 2006/05/16 16:05:20CEST zi82ot 
AUXPOWER/batteryBackup only used in BCM, can be deleted in all others, sequence-problem
Revision 1.2 2006/04/11 15:50:39CEST zi82ot 
RULE/note and RULE_STATE/note not considered
Revision 1.1 2006/04/11 10:19:19CEST zi82ot 
Initial revision
Member added to project f:/MKS_Repository/Fire/MagicPanel/Source/PCTools/Transformer/Transformer.pj
-->
  <cfg:Stylesheet version="$Revision: 1.54 $"/>
  <xsl:param name="NotCompared" select="'NOT-COMPARED'"/>
  <xsl:param name="ItemUnused" select="'NOT-COMPARED-item-unused'"/>
  <xsl:param name="SI_Zero" select="'SI-ZERO'"/>
  <xsl:param name="SI_Zero2" select="'SI-ZERO or missing'"/>
  <xsl:param name="ConfigIncomplete" select="'CONFIG-INCOMPLETE'"/>
  <xsl:param name="RemoveAttributes" select="'true'"/>
  <xsl:output method="xml" indent="yes"/>
  <!--****************  GENERIC PART iterate thru all nodes and copy elements and attribute ***********************-->
  <!-- copies each node implicitly by match 'node()', the attributes need to be copied explicitly by template @*-->
  <xsl:template match="*">
    <xsl:element name="{name()}">
      <!-- RPS writes newlines into empty elements sometimes -->
      <xsl:choose>
        <xsl:when test="./* = false()">
          <xsl:value-of select="normalize-space(.)"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:apply-templates select="@* | node()"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:element>
  </xsl:template>
  <!-- explicitly copy attributes -->
  <xsl:template match="@*">
    <xsl:if test="$RemoveAttributes = 'false'">
      <xsl:copy/>
    </xsl:if>
  </xsl:template>
  <!--****************  SPECIAL PART modifications to certain nodes ***********************-->
  <!--  SET NOT COMPARED begin-->
  <xsl:template match="PANEL/siNumber">
    <xsl:element name="siNumber">
      <xsl:value-of select="$NotCompared"/>
    </xsl:element>
  </xsl:template>
  <!-- -->
  <xsl:template match="LSN300_MODULE | LSN1500_MODULE">
    <xsl:element name="{name()}">
      <xsl:for-each select="*">
        <xsl:choose>
          <!--  lastElement of a STUB must be 255 -->
          <!-- drop LSN_BUS if no elements -->
          <xsl:when test="name() = 'LSN_BUS' and count(*) = 4"/>
          <!-- topology is invalid if no elements -->
          <xsl:when test="name() = 'topology' and ../nrOfElements = '0'">
            <xsl:element name="{name()}">
              <xsl:value-of select="$NotCompared"/>
            </xsl:element>
          </xsl:when>
          <!-- if LOOP is configured and lastElement is 255, lastElement was not set yet -->
          <xsl:when test="name() = 'topology' and . = 'TOPOT_LOOP' and ../lastElement = '255'">
            <xsl:element name="{name()}">
              <xsl:value-of select="$ConfigIncomplete"/>
            </xsl:element>
          </xsl:when>
          <!-- if LOOP is configured and lastElement is 0, lastElement was not set yet -->
          <xsl:when test="name() = 'topology' and ../lastElement = '0'">
            <xsl:element name="{name()}">
              <xsl:value-of select="$ConfigIncomplete"/>
            </xsl:element>
          </xsl:when>
          <xsl:otherwise>
            <xsl:apply-templates select="."/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <!-- -->
  <xsl:template match="LSN_BUS">
    <xsl:element name="{name()}">
      <xsl:choose>
        <!-- in the new structur from 2.7.0 all LSN-elements are on one level and can be sorted-->
        <xsl:when test="descendant::backPointer = true()">
          <xsl:for-each select="*">
            <xsl:sort select="./comAdr" data-type="number"/>
            <xsl:apply-templates select="."/>
          </xsl:for-each>
        </xsl:when>
        <xsl:otherwise>
          <xsl:for-each select="*">
            <xsl:apply-templates select="."/>
          </xsl:for-each>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:element>
  </xsl:template>
  <!-- -->
  <xsl:template match="CUSTOMER_INFO/x400">
    <xsl:element name="x400">
      <xsl:value-of select="$NotCompared"/>
    </xsl:element>
  </xsl:template>
  <!-- -->
  <xsl:template match="SUPPORT_INFO/x400">
    <xsl:element name="x400">
      <xsl:value-of select="$NotCompared"/>
    </xsl:element>
  </xsl:template>
  <!-- -->
  <xsl:template match="CONFIG_INFO">
    <xsl:element name="{name()}">
      <xsl:value-of select="$NotCompared"/>
    </xsl:element>
  </xsl:template>
  <!-- rsn-->
  <xsl:template match="rsn">
    <xsl:element name="rsn">
      <xsl:value-of select="number(.)"/>
    </xsl:element>
  </xsl:template>
  <!-- correct empty subNumber -->
  <xsl:template match="subNumber">
    <xsl:element name="subNumber">
      <xsl:choose>
        <xsl:when test=". = '' and ../siNumber = '0'">
          <xsl:text>0</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="."/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:element>
  </xsl:template>
  <!-- remove leading group.node from counter number -->
  <xsl:template match="SUMCOUNTER/counter">
    <xsl:if test="string-length() != 0">
      <!-- RPS adds empty counters sometimes -->
      <xsl:element name="counter">
        <xsl:value-of select="."/>
      </xsl:element>
    </xsl:if>
  </xsl:template>
  <!-- remove  if unconfigured siNumber == 0, applies to ONBOARD and LSN1500_MODULE -->
  <xsl:template match="GROUND">
    <xsl:if test="siNumber != 0">
      <xsl:element name="{name()}">
        <xsl:apply-templates select="*"/>
      </xsl:element>
    </xsl:if>
  </xsl:template>
  <!-- delete idOfAccesspointToHangUp -->
  <xsl:template match="idOfAccesspointToHangUp"/>
  <!-- delete mAddressCardTimeDivider -->
  <xsl:template match="mAddressCardTimeDivider"/>
  <!-- delete OPERATOR/pwd-->
  <xsl:template match="OPERATOR/pwd"/>
  <!-- delete RULE/note and RULE_STATE/note if not uploaded-->
  <xsl:variable name="SchemaVersion">
    <xsl:choose>
      <xsl:when test="/CONFIG_NETWORK/HEADER/dataVersion = true()">
        <xsl:value-of select="/CONFIG_NETWORK/HEADER/dataVersion"/>
      </xsl:when>
      <xsl:otherwise>0.0.0</xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <xsl:template match="RULE/note">
    <xsl:if test="user:IsVersionGreaterOrEqual(string($SchemaVersion),'2.8.4')">
      <xsl:element name="{name()}">
        <xsl:value-of select="."/>
      </xsl:element>
    </xsl:if>
  </xsl:template>
  <xsl:template match="RULE_STATE/note">
    <xsl:if test="user:IsVersionGreaterOrEqual(string($SchemaVersion),'2.8.4')">
      <xsl:element name="{name()}">
        <xsl:value-of select="."/>
      </xsl:element>
    </xsl:if>
  </xsl:template>
  <!-- delete HEADER/adapted-->
  <xsl:template match="HEADER/adapted">
  </xsl:template>
  <!-- delete HEADER/xmlValidation-->
  <xsl:template match="HEADER/xmlValidation">
  </xsl:template>
  <!-- delete AUXPOWER/batteryBackup is needed and set in BC_Module only -->
  <!-- delete LSN300_MODULE/AUXPOWER/batteryBackup -->
  <xsl:template match="LSN300_MODULE/AUXPOWER/batteryBackup">
  </xsl:template>
  <!-- delete LSN300_MODULE/AUXPOWER/batteryBackup -->
  <!-- delete AUXPOWER_LSNI_CONV4/batteryBackup -->
  <xsl:template match="AUXPOWER_LSNI_CONV4/batteryBackup">
  </xsl:template>
  <!-- delete AUXPOWER_LSNI_CONV4/batteryBackup -->
  <!-- delete CONVENTIONAL_MODULE/AUXPOWER/batteryBackup -->
  <xsl:template match="CONVENTIONAL_MODULE/AUXPOWER/batteryBackup">
  </xsl:template>
  <!-- delete CONVENTIONAL_MODULE/AUXPOWER/batteryBackup -->
  <!-- delete ENOT_MODULE/AUXPOWER/batteryBackup -->
  <xsl:template match="ENOT_MODULE/AUXPOWER/batteryBackup">
  </xsl:template>
  <!-- delete ENOT_MODULE/AUXPOWER/batteryBackup -->
  <!-- delete NAC_MODULE/AUXPOWER/batteryBackup -->
  <xsl:template match="NAC_MODULE/AUXPOWER/batteryBackup">
  </xsl:template>
  <!-- delete NAC_MODULE/AUXPOWER/batteryBackup -->
  <!-- do not copy empty _ADMIN nodes -->
  <xsl:template match="MTS_ADMIN | COMMUNICATION_DEVICES | ADDRESS_MANAGEMENT">
    <xsl:if test="*">
      <xsl:element name="{name()}">
        <xsl:apply-templates select="*"/>
      </xsl:element>
    </xsl:if>
  </xsl:template>
  <!-- delete because of RPS does not create it -->
  <xsl:template match="FBF_ADMIN"/>
  <xsl:template match="HVAC_ADMIN">
    <xsl:if test="HVAC">
      <xsl:element name="{name()}">
        <xsl:apply-templates select="*"/>
      </xsl:element>
    </xsl:if>
  </xsl:template>
  <xsl:template match="FBF100/cityTieAddress">
    <xsl:element name="{name()}">
      <xsl:choose>
        <xsl:when test="node() = 'MP_SI_INVALID.*.*'">
          <!-- makes anyhow no sense as configuration -->
          <xsl:text>MP_SI_INVALID.0.0</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="."/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:element>
  </xsl:template>
  <xsl:template match="MAINPOWER">
    <xsl:element name="{name()}">
      <xsl:for-each select="*">
        <xsl:element name="{name()}">
          <xsl:choose>
            <xsl:when test="../siNumber = '0' and name() = 'delayForTrouble'">
              <xsl:value-of select="$NotCompared"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:apply-templates select="."/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:element>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <!--  ******** NOT COMPARED ******** end-->
  <!--  SET ITEM UNUSDED begin-->
  <xsl:template match="RLHV_MODULE | LSN_BUS/RLHVI">
    <xsl:element name="{name()}">
      <xsl:for-each select="*">
        <xsl:sort data-type="number" select="port"/>
        <xsl:choose>
          <xsl:when test="(name() = 'RELAY' or name() = 'LSNRELAY') and ./port = '1'">
            <xsl:apply-templates select="."/>
            <xsl:if test="../INPUT[port = '3'] = true()">
              <xsl:apply-templates select="../INPUT[port = '3']"/>
            </xsl:if>
            <xsl:if test="../INPUT[port = '5'] = true()">
              <xsl:apply-templates select="../INPUT[port = '5']"/>
            </xsl:if>
          </xsl:when>
          <xsl:when test="(name() = 'RELAY' or name() = 'LSNRELAY') and ./port = '2'">
            <xsl:apply-templates select="."/>
            <xsl:if test="../INPUT[port = '4'] = true()">
              <xsl:apply-templates select="../INPUT[port = '4']"/>
            </xsl:if>
          </xsl:when>
          <xsl:otherwise>
          <xsl:if test="name() != 'INPUT'">
            <xsl:apply-templates select="."/>
            </xsl:if>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <xsl:template match="RLHV_MODULE/RELAY">
    <xsl:element name="{name()}">
      <xsl:for-each select="*">
        <xsl:choose>
          <xsl:when test="../siNumber = '0'">
            <xsl:choose>
              <!-- the physical properties of the INPUT are contained in RELAY, so we need to compare them even if RELAY has siNumber = zero, ie. logically unconfigured -->
              <xsl:when test="name() = 'supervised' or name() = 'siNumber' or name() = 'subNumber' or name() = 'port' or name() = 'feedback' or name() = 'feedbackEOL' or name() = 'feedbackActivation'">
                <xsl:apply-templates select="."/>
              </xsl:when>
              <xsl:when test="name() = 'feedbackDelay'">
                <xsl:choose>
                  <!-- feedbackDelay of second RELAY is used even if siNumber is zero in case of MP_ST_FIREEX_VDS_05 -->
                  <xsl:when test="../../RELAY[1]/subType = 'MP_ST_FIREEX_VDS_05' and ../../RELAY[1]/siNumber != '0'">
                    <xsl:apply-templates select="."/>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:element name="{name()}">
                      <xsl:value-of select="$SI_Zero"/>
                    </xsl:element>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:when>
              <xsl:otherwise>
                <xsl:element name="{name()}">
                  <xsl:value-of select="$SI_Zero"/>
                </xsl:element>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:otherwise>
            <xsl:apply-templates select="."/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <!--   Copy if configured i.e. if siNumber != 0 -->
  <xsl:template match="PULLSTATION | NAC_ZONE | RELAY | MSS401 | MSS400 | FULLEON_BASE | FULLEON_STANDALONE  | INPUT | RLHVI | LSNRELAY | NSB100 | CTIE | UNLOCKAPPLIANCE">
    <xsl:call-template name="CopyIfConfigured">
      <xsl:with-param name="NodeName" select="name()"/>
    </xsl:call-template>
  </xsl:template>
  <xsl:template name="CopyIfConfigured">
    <xsl:param name="NodeName"/>
    <xsl:element name="{$NodeName}">
      <xsl:for-each select="*">
        <xsl:choose>
          <xsl:when test="../siNumber = '0' or ../siNumber = ''">
            <xsl:choose>
              <xsl:when test="name() = 'port' or name() = 'comAdr' or name() = 'independentInput' or name() = 'independentInput2' or name() = 'feedbackVariant' or name() = 'feedbackVariant1'  or name() = 'feedbackVariant2' or name() = 'drillPattern' or name() = 'testActivationPattern'">
                <xsl:apply-templates select="."/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:element name="{name()}">
                  <xsl:value-of select="$SI_Zero"/>
                </xsl:element>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:when>
          <xsl:otherwise>
            <xsl:apply-templates select="."/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <!--  ******** ITEM UNUSDED ******** end-->
  <!-- ****** RULE DEPTH is TWO ******* begin -->
  <!-- STATUS begin-->
  <xsl:template match="STATUS_ADMIN">
    <xsl:element name="{name()}">
      <xsl:for-each select="STATUS_GROUP">
        <xsl:sort select="siNumber" data-type="number"/>
        <xsl:apply-templates select="."/>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <!-- -->
  <!--   -->
  <xsl:template match="STATUS_GROUP">
    <xsl:element name="{name()}">
      <xsl:element name="siNumber">
        <xsl:value-of select="siNumber"/>
      </xsl:element>
      <xsl:element name="label">
        <xsl:value-of select="label"/>
      </xsl:element>
      <xsl:for-each select="STATUS">
        <xsl:sort select="subNumber" data-type="number"/>
        <xsl:apply-templates select="."/>
      </xsl:for-each>
      <xsl:call-template name="SortWriteRules"/>
    </xsl:element>
  </xsl:template>
  <!--   -->
  <!--   -->
  <xsl:template match="STATUS">
    <xsl:element name="{name()}">
      <xsl:element name="subNumber">
        <xsl:value-of select="subNumber"/>
      </xsl:element>
      <xsl:call-template name="SortWriteRules"/>
    </xsl:element>
  </xsl:template>
  <!-- STATUS  end-->
  <!-- GROUP begin-->
  <xsl:template match="GROUP_ADMIN">
    <xsl:element name="{name()}">
      <xsl:for-each select="GROUP">
        <xsl:sort select="siNumber" data-type="number"/>
        <xsl:apply-templates select="."/>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <!-- -->
  <!--   -->
  <xsl:template match="GROUP">
    <xsl:element name="{name()}">
      <xsl:element name="siNumber">
        <xsl:value-of select="siNumber"/>
      </xsl:element>
      <xsl:element name="label">
        <xsl:value-of select="label"/>
      </xsl:element>
      <xsl:element name="alarmInvestigation">
        <xsl:value-of select="alarmInvestigation"/>
      </xsl:element>
      <xsl:element name="investigationTime">
        <xsl:value-of select="investigationTime"/>
      </xsl:element>
      <xsl:element name="dayNightMode">
        <xsl:value-of select="dayNightMode"/>
      </xsl:element>
      <xsl:for-each select="POINT">
        <xsl:sort select="subNumber" data-type="number"/>
        <xsl:apply-templates select="."/>
      </xsl:for-each>
      <xsl:call-template name="SortWriteRules"/>
    </xsl:element>
  </xsl:template>
  <!--   -->
  <!--   -->
  <xsl:template match="POINT">
    <xsl:element name="{name()}">
      <xsl:element name="subNumber">
        <xsl:value-of select="subNumber"/>
      </xsl:element>
      <xsl:call-template name="SortWriteRules"/>
    </xsl:element>
  </xsl:template>
  <!-- GROUP  end-->
  <!-- NAC_ADMIN begin -->
  <xsl:template match="NAC_ADMIN">
    <xsl:if test="*">
      <xsl:element name="{name()}">
        <xsl:for-each select="NAC_GROUP">
          <xsl:sort select="siNumber" data-type="number"/>
          <xsl:apply-templates select="."/>
        </xsl:for-each>
      </xsl:element>
    </xsl:if>
  </xsl:template>
  <!-- -->
  <!-- OPERATOR_ADMIN begin -->
  <xsl:template match="OPERATOR_ADMIN">
    <xsl:element name="{name()}">
      <xsl:for-each select="OPERATOR">
        <xsl:sort select="id" data-type="number"/>
        <xsl:apply-templates select="."/>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <!-- -->
  <!--   -->
  <xsl:template match="NAC_GROUP">
    <xsl:element name="{name()}">
      <xsl:element name="siNumber">
        <xsl:value-of select="siNumber"/>
      </xsl:element>
      <xsl:element name="label">
        <xsl:value-of select="label"/>
      </xsl:element>
      <xsl:for-each select="NAC">
        <xsl:sort select="subNumber" data-type="number"/>
        <xsl:apply-templates select="."/>
      </xsl:for-each>
      <xsl:call-template name="SortWriteRules"/>
    </xsl:element>
  </xsl:template>
  <!--   -->
  <!--   -->
  <xsl:template match="NAC">
    <xsl:element name="{name()}">
      <xsl:element name="subNumber">
        <xsl:value-of select="subNumber"/>
      </xsl:element>
      <xsl:call-template name="SortWriteRules"/>
    </xsl:element>
  </xsl:template>
  <!-- NAC_ADMIN end-->
  <!-- ****** RULE DEPTH is TWO ******* end -->
  <!-- ****** RULE DEPTH is ONE  ******* begin -->
  <!-- SETS begin -->
  <xsl:template match="SETS_ADMIN">
    <xsl:element name="{name()}">
      <xsl:for-each select="SET">
        <xsl:sort select="siNumber" data-type="number"/>
        <xsl:element name="{name()}">
          <xsl:element name="siType">
            <xsl:value-of select="siType"/>
          </xsl:element>
          <xsl:element name="siNumber">
            <xsl:value-of select="siNumber"/>
          </xsl:element>
          <xsl:element name="label">
            <xsl:value-of select="label"/>
          </xsl:element>
          <xsl:for-each select="element">
            <xsl:sort select="." data-type="text"/>
            <!-- check if the current element was already proccessed -->
            <!-- RPS adds the same SI multiple times sometimes -->
            <xsl:if test="count(preceding-sibling::element[current() = node()]) = 0">
              <xsl:element name="element">
                <xsl:value-of select="."/>
              </xsl:element>
            </xsl:if>
          </xsl:for-each>
          <xsl:call-template name="SortWriteRules"/>
        </xsl:element>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <!-- SETS end-->
  <!-- CITYTIE_ADMIN begin -->
  <xsl:template match="CITYTIE_ADMIN">
    <xsl:if test="*">
      <xsl:element name="{name()}">
        <xsl:for-each select="CITYTIE">
          <xsl:sort select="siNumber" data-type="number"/>
          <xsl:element name="{name()}">
            <xsl:element name="siNumber">
              <xsl:value-of select="siNumber"/>
            </xsl:element>
            <xsl:call-template name="SortWriteRules"/>
          </xsl:element>
        </xsl:for-each>
      </xsl:element>
    </xsl:if>
  </xsl:template>
  <!-- CITYTIE_ADMIN end-->
  <!-- CONTROL_ADMIN begin -->
  <xsl:template match="CONTROL_ADMIN">
    <xsl:if test="*">
      <xsl:element name="{name()}">
        <xsl:for-each select="CONTROL">
          <xsl:sort select="siNumber" data-type="number"/>
          <xsl:element name="{name()}">
            <xsl:element name="siNumber">
              <xsl:value-of select="siNumber"/>
            </xsl:element>
            <xsl:call-template name="SortWriteRules"/>
          </xsl:element>
        </xsl:for-each>
      </xsl:element>
    </xsl:if>
  </xsl:template>
  <!-- CONTROL_ADMIN end-->
  <!-- DOORHOLDER_ADMIN begin -->
  <xsl:template match="DOORHOLDER_ADMIN">
    <xsl:if test="*">
      <xsl:element name="{name()}">
        <xsl:for-each select="DOORHOLDER">
          <xsl:sort select="siNumber" data-type="number"/>
          <xsl:element name="{name()}">
            <xsl:element name="siNumber">
              <xsl:value-of select="siNumber"/>
            </xsl:element>
            <xsl:call-template name="SortWriteRules"/>
          </xsl:element>
        </xsl:for-each>
      </xsl:element>
    </xsl:if>
  </xsl:template>
  <!-- DOORHOLDER_ADMIN end-->
  <!-- FIRE_ADMIN begin -->
  <xsl:template match="FIRE_ADMIN">
    <xsl:if test="*">
      <xsl:element name="{name()}">
        <xsl:for-each select="FIRE">
          <xsl:sort select="siNumber" data-type="number"/>
          <xsl:element name="{name()}">
            <xsl:element name="siNumber">
              <xsl:value-of select="siNumber"/>
            </xsl:element>
            <xsl:call-template name="SortWriteRules"/>
          </xsl:element>
        </xsl:for-each>
      </xsl:element>
    </xsl:if>
  </xsl:template>
  <!-- FIRE_ADMIN end-->
  <!-- KEYDEPOT_ADMIN begin -->
  <xsl:template match="KEYDEPOT_ADMIN">
    <xsl:if test="*">
      <xsl:element name="{name()}">
        <xsl:for-each select="KEYDEPOT">
          <xsl:sort select="siNumber" data-type="number"/>
          <xsl:element name="{name()}">
            <xsl:element name="siNumber">
              <xsl:value-of select="siNumber"/>
            </xsl:element>
            <xsl:call-template name="SortWriteRules"/>
          </xsl:element>
        </xsl:for-each>
      </xsl:element>
    </xsl:if>
  </xsl:template>
  <!-- KEYDEPOT_ADMIN end-->
  <!-- PRINTER_ADMIN begin -->
  <!-- HIDE -->
  <xsl:template match="_PRINTER_ADMIN">
    <xsl:element name="{name()}">NOT_COMPARED_UNTIL_BUG_FIXED</xsl:element>
  </xsl:template>
  <xsl:template match="PRINTER_ADMIN">
    <xsl:if test="*">
      <xsl:element name="{name()}">
        <xsl:for-each select="PRINTER">
          <xsl:sort select="siNumber" data-type="number"/>
          <xsl:element name="{name()}">
            <xsl:element name="siNumber">
              <xsl:value-of select="siNumber"/>
            </xsl:element>
            <xsl:element name="label">
              <xsl:value-of select="label"/>
            </xsl:element>
            <xsl:element name="printerType">
              <xsl:value-of select="printerType"/>
            </xsl:element>
            <xsl:element name="connectedWith">
              <xsl:value-of select="connectedWith"/>
            </xsl:element>
            <xsl:if test="UART">
              <xsl:apply-templates select="UART"/>
            </xsl:if>
            <xsl:if test="OB_UART">
              <xsl:apply-templates select="OB_UART"/>
            </xsl:if>
            <xsl:call-template name="SortWriteRules"/>
          </xsl:element>
        </xsl:for-each>
      </xsl:element>
    </xsl:if>
  </xsl:template>
  <!-- PRINTER_ADMIN end-->
  <xsl:template match="UART">
    <xsl:element name="UART">
      <xsl:element name="number">
        <xsl:value-of select="number"/>
      </xsl:element>
      <xsl:element name="speed">
        <xsl:value-of select="speed"/>
      </xsl:element>
      <xsl:element name="frame">
        <xsl:value-of select="frame"/>
      </xsl:element>
    </xsl:element>
  </xsl:template>
  <xsl:template match="OB_UART">
    <xsl:element name="OB_UART">
      <xsl:element name="number">
        <xsl:value-of select="number"/>
      </xsl:element>
      <xsl:element name="speed">
        <xsl:value-of select="speed"/>
      </xsl:element>
      <xsl:element name="frame">
        <xsl:value-of select="frame"/>
      </xsl:element>
      <xsl:element name="irdaEnabled">
        <xsl:value-of select="irdaEnabled"/>
      </xsl:element>
    </xsl:element>
  </xsl:template>
  <!-- ********* RULE DEPTH is ONE ********* end -->
  <!-- ****** RULE DEPTH is ZERO  ******* begin -->
  <!--   PANEL_ADMINISTRATION begin -->
  <!-- HIDE -->
  <xsl:template match="_PANEL_ADMINISTRATION">
    <xsl:element name="{name()}">NOT_COMPARED_CANNOT_BE_SORTED</xsl:element>
  </xsl:template>
  <xsl:template match="PANEL_ADMINISTRATION">
    <xsl:element name="{name()}">
      <xsl:call-template name="SortWriteRules"/>
    </xsl:element>
  </xsl:template>
  <!--   PANEL ADMINISTRATION end -->
  <!-- ****** RULE DEPTH is ZERO ******* end -->
  <!--   ######################################## -->
  <!-- 
  <xsl:template match="RULE_STATE">
    <xsl:element name="{name()}">
      <xsl:apply-templates/>
    </xsl:element>
  </xsl:template>
  -->
  <!-- Sorting routines -->
  <xsl:template name="SortWriteRules">
    <xsl:if test="RULE = true()">
      <xsl:call-template name="SortWriteRULES"/>
    </xsl:if>
    <!--
    <xsl:if test="RULE_STATE = true()">
      <xsl:call-template name="SortWrite_RULE_STATE"/>
    </xsl:if>
    -->
    <xsl:if test="RULE_STATE_BLOCK = true()">
      <xsl:call-template name="SortWrite_RULE_STATE_BLOCKS"/>
    </xsl:if>
  </xsl:template>
  <!--  NOT USED the old version without RULE_STATE_BLOCK -->
  <xsl:template name="SortWrite_RULE_STATE">
    <xsl:for-each select="RULE_STATE/CONDITION_COUNTER">
      <xsl:sort select="conditionNumber"/>
      <xsl:apply-templates select="../."/>
    </xsl:for-each>
    <xsl:for-each select="RULE_STATE/CONDITION_STATE">
      <xsl:sort select="conditionNumber"/>
      <xsl:apply-templates select="../."/>
    </xsl:for-each>
    <xsl:for-each select="RULE_STATE">
      <!-- special handling for else clauses in state dependend rules, that are RULE_STATE-elements not containing counter or state -->
      <xsl:if test="CONDITION_STATE = false() and CONDITION_COUNTER = false()">
        <xsl:apply-templates select="."/>
      </xsl:if>
    </xsl:for-each>
  </xsl:template>
  <!--   -->
  <xsl:template name="SortWriteRULES">
    <xsl:for-each select="RULE">
      <!-- sort cannot be done using the RULE itself because it contains note, which is not in the uploaded file-->
      <xsl:sort select="TRIGGER_ADMIN | TRIGGER_COUNTER | TRIGGER_DOWNLOAD  | TRIGGER_STATE | TRIGGER_USER | TRIGGER_ELAPSE"/>
      <xsl:apply-templates select="."/>
    </xsl:for-each>
  </xsl:template>
  <!--  START of the new version considering RULE_STATE_BLOCKS -->
  <xsl:template name="SortWrite_RULE_STATE_BLOCKS">
    <xsl:for-each select="RULE_STATE_BLOCK">
      <xsl:sort select="."/>
      <xsl:apply-templates select="."/>
    </xsl:for-each>
  </xsl:template>
  <!--   -->
  <xsl:template match="RULE_STATE_BLOCK">
    <xsl:element name="RULE_STATE_BLOCK">
      <xsl:for-each select="*">
        <xsl:apply-templates select="."/>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <!--   -->
  <xsl:template match="RULE_STATE">
    <xsl:element name="RULE_STATE">
      <xsl:apply-templates select="note"/>
      <xsl:for-each select="CONDITION_STATE | CONDITION_COUNTER | CONDITION_ELAPSE">
        <xsl:sort select="."/>
        <xsl:apply-templates select="."/>
      </xsl:for-each>
      <xsl:for-each select="ADMINISTRATION | BUZZER_ACTION | CITYTIE_ACTION | CONTROL_ACTION | DIALER_ACTION | DOORHOLDER_ACTION | FAT_ACTION | FBF_ACTION | FIRE_ACTION | HVAC_ACTION | KEYDEPOT_ACTION | NAC_ACTION | PRINTER_ACTION | SET_ACTION | STATUS_ACTION">
        <xsl:sort select="."/>
        <xsl:apply-templates select="."/>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <!--   -->
  <xsl:template match="CONDITION_STATE">
    <xsl:element name="CONDITION_STATE">
      <xsl:for-each select="*">
        <xsl:choose>
          <xsl:when test="name() = 'isRemote' and ../conditionNumber = '0'">
            <xsl:element name="{name()}">
              <xsl:value-of select="$ConfigIncomplete"/>
            </xsl:element>
          </xsl:when>
          <xsl:otherwise>
            <xsl:apply-templates select="."/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <!--   -->
  <xsl:template match="TRIGGER_STATE">
    <xsl:element name="TRIGGER_STATE">
      <xsl:for-each select="*">
        <xsl:choose>
          <xsl:when test="name() = 'isRemote' and ../triggerNumber = '0'">
            <xsl:element name="{name()}">
              <xsl:value-of select="$ConfigIncomplete"/>
            </xsl:element>
          </xsl:when>
          <xsl:otherwise>
            <xsl:apply-templates select="."/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <!--  END of the new version considering RULE_STATE_BLOCKS -->
  <!-- sort TRANSFER -->
  <xsl:template match="TRANSFER">
    <xsl:element name="TRANSFER">
      <xsl:for-each select="*">
        <xsl:if test="name() != 'ATMODEM' and name() != 'OB_UART'">
          <xsl:apply-templates select="."/>
        </xsl:if>
      </xsl:for-each>
      <xsl:element name="OB_UART">
        <xsl:apply-templates select="OB_UART"/>
      </xsl:element>
      <xsl:element name="ATMODEM">
        <xsl:apply-templates select="ATMODEM"/>
      </xsl:element>
    </xsl:element>
  </xsl:template>
  <!-- sort DAYS -->
  <xsl:template match="DAYS">
    <xsl:element name="DAYS">
      <xsl:for-each select="*">
        <xsl:sort select="."/>
        <xsl:apply-templates select="."/>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <!-- sort HOLIDAY -->
  <xsl:template match="HOLIDAY">
    <xsl:element name="HOLIDAY">
      <xsl:for-each select="*">
        <xsl:sort select="."/>
        <xsl:apply-templates select="."/>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <!-- sort WEEKDAY -->
  <xsl:template match="WEEKDAY">
    <xsl:element name="WEEKDAY">
      <xsl:for-each select="*">
        <xsl:sort select="."/>
        <xsl:apply-templates select="."/>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <!-- sort SPECIALDAY -->
  <xsl:template match="SPECIALDAY">
    <xsl:element name="SPECIALDAY">
      <xsl:for-each select="*">
        <xsl:sort select="."/>
        <xsl:apply-templates select="."/>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <!-- tidyup PROGRAM -->
  <xsl:template match="PROGRAM">
    <xsl:element name="PROGRAM">
      <xsl:element name="id">
        <xsl:value-of select="id"/>
      </xsl:element>
      <xsl:for-each select="time">
        <xsl:sort/>
        <xsl:choose>
          <xsl:when test="name() = 'time' and . = ''">
            <!-- dont write empty time elements -->
          </xsl:when>
          <xsl:otherwise>
            <xsl:apply-templates select="."/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <!-- PROTOCOL_4A if not connected -->
  <xsl:template match="PROTOCOL_4A">
    <xsl:if test="../connectedWith != '0.0.0.0'">
      <xsl:element name="PROTOCOL_4A">
        <xsl:apply-templates select="*"/>
      </xsl:element>
    </xsl:if>
  </xsl:template>
  <!-- number of UART or OB_UART is not used -->
  <xsl:template match="UART | OB_UART">
    <xsl:element name="{name()}">
      <xsl:for-each select="*">
        <xsl:choose>
          <xsl:when test="name() = 'number'">
            <xsl:element name="number">
              <xsl:value-of select="$ItemUnused"/>
            </xsl:element>
          </xsl:when>
          <xsl:otherwise>
            <xsl:apply-templates select="."/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <!-- VAS_TRIGGERS cannot be upoaded again if siNumber was 0 because there are no addresses stored in config-->
  <xsl:template match="VAS_TRIGGER">
    <xsl:if test="siNumber != '0'">
      <xsl:element name="{name()}">
        <xsl:element name="vasTriggerNumber">
          <xsl:value-of select="vasTriggerNumber"/>
        </xsl:element>
        <xsl:element name="siType">
          <xsl:value-of select="siType"/>
        </xsl:element>
        <xsl:element name="siNumber">
          <xsl:value-of select="siNumber"/>
        </xsl:element>
        <xsl:element name="subNumber">
          <xsl:value-of select="subNumber"/>
        </xsl:element>
        <xsl:element name="label">
          <xsl:value-of select="label"/>
        </xsl:element>
        <xsl:choose>
          <xsl:when test="siType = 'MP_SI_NAC'">
            <xsl:element name="bypassable">
              <xsl:value-of select="bypassable"/>
            </xsl:element>
            <xsl:element name="blockable">
              <xsl:value-of select="blockable"/>
            </xsl:element>
            <xsl:element name="silenceable">
              <xsl:value-of select="silenceable"/>
            </xsl:element>
            <xsl:element name="drillable">
              <xsl:value-of select="drillable"/>
            </xsl:element>
            <xsl:element name="feedbackDelay">
              <xsl:value-of select="feedbackDelay"/>
            </xsl:element>
          </xsl:when>
          <xsl:otherwise>
            <xsl:element name="bypassable">
              <xsl:value-of select="$NotCompared"/>
            </xsl:element>
            <xsl:element name="blockable">
              <xsl:value-of select="$NotCompared"/>
            </xsl:element>
            <xsl:element name="silenceable">
              <xsl:value-of select="$NotCompared"/>
            </xsl:element>
            <xsl:element name="drillable">
              <xsl:value-of select="$NotCompared"/>
            </xsl:element>
            <xsl:element name="feedbackDelay">
              <xsl:value-of select="$NotCompared"/>
            </xsl:element>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:element>
    </xsl:if>
  </xsl:template>
  <!-- shorttext for objects with siNumber zero are not stored in pctrl -->
  <xsl:template match="label | bypassable | blockable">
    <xsl:element name="{name()}">
      <xsl:choose>
        <xsl:when test="../siNumber = '0'">
          <xsl:text>NOT COMPARED IF SI-ZERO</xsl:text>
        </xsl:when>
        <xsl:when test="parent::COUNTER_LIFE_TIME">
          <xsl:text>NOT COMPARED NOT USED</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="."/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:element>
  </xsl:template>
  <!-- sort activity texts by element name -->
  <xsl:template match="ACTIVITYTEXTS">
    <xsl:element name="{name()}">
      <xsl:comment>sorted by element names</xsl:comment>
      <xsl:for-each select="*">
        <xsl:sort select="name(.)"/>
        <xsl:element name="{name(.)}">
          <xsl:value-of select="normalize-space(.)"/>
        </xsl:element>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <!-- GLTZONE with siNumber zero -->
  <xsl:template match="GLTZONE">
    <xsl:element name="{name()}">
      <xsl:for-each select="*">
        <xsl:element name="{name()}">
          <xsl:choose>
            <xsl:when test="../siNumber = '0'">
              <xsl:choose>
                <xsl:when test="name() = 'automaticDetectors' or name() = 'label'">
                  <xsl:value-of select="$NotCompared"/>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="."/>
                </xsl:otherwise>
              </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="."/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:element>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>
  <!-- LSN_NAC as NAC or CONTROL -->
  <xsl:template match="LSN_NAC/NAC_ZONE | LSN_NAC/RELAY">
    <xsl:choose>
      <xsl:when test="siNumber = '0'">
        <xsl:element name="NAC_ZONE_OR_RELAY">
          <xsl:value-of select="$ItemUnused"/>
        </xsl:element>
      </xsl:when>
      <xsl:otherwise>
        <xsl:element name="{name()}">
          <xsl:for-each select="*">
            <xsl:apply-templates select="."/>
          </xsl:for-each>
        </xsl:element>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template match="color">
	<xsl:if test="text()!='LCT_UNUSED'">
		<xsl:element name="color"><xsl:value-of select="."/></xsl:element>
	</xsl:if>
  </xsl:template>
    <!-- delete color if LCT_UNUSED-->
  <xsl:template match="STATUS_ACTION/color">
	<xsl:choose>
		<xsl:when test="text()='LCT_UNUSED'">
			<!-- delete -->
		</xsl:when>
		<xsl:otherwise>
        <xsl:element name="{name()}">
            <xsl:value-of select="."/>
        </xsl:element>
		</xsl:otherwise>
	</xsl:choose>
  </xsl:template>
<!-- Compare versions strings of form 'major.minor.sub' by script -->
  <msxsl:script language="javascript" implements-prefix="user">
   function IsVersionGreaterOrEqual(left,right)
   {
      // version strings of the form aa.bb.cc can be compared
      // aa bb cc may only contain 2 digits
      var versionLeft = 0;
      var versionRight = 0;
      var tokenLeft = left.split(".");
      versionLeft = Number(tokenLeft[0]) * 10000;
      versionLeft += Number(tokenLeft[1]) * 100;
      versionLeft += Number(tokenLeft[2]);
      var tokenRight = right.split(".");
      versionRight = Number(tokenRight[0]) * 10000;
      versionRight += Number(tokenRight[1]) * 100;
      versionRight += Number(tokenRight[2]);
      return versionLeft >= versionRight;
   }
</msxsl:script>
</xsl:stylesheet>
